# Tests Must Pass Workflow

A workflow that ensures tests pass before continuing. If tests fail, it automatically fixes the issues and runs tests again in a loop until they pass.

## How It Works

This workflow implements a guaranteed test execution and fixing loop using a clever prompt-based state management:

1. **Run Tests** - Executes `npm test` and captures output with exit code
2. **Clear if Passed** - If exit code is 0 (tests passed), clears the prompt
3. **Fix and Loop** - If prompt is not empty (tests failed), fixes issues and loops back

### Loop Mechanics

The workflow uses prompt state to control the loop:

- **Tests Pass**: Exit code is 0 → prompt is cleared → "Fix and Loop" step is skipped (empty prompt) → workflow ends
- **Tests Fail**: Exit code is non-zero → prompt contains error output → "Fix and Loop" executes → fixes issues → loops back to "Run Tests"

This avoids running tests twice in conditions and provides the AI with full test output for analysis.

## Usage

### Standalone Usage (Button Trigger)

1. Click the "Tests Must Pass" button in the Supercode UI
2. The workflow will run tests and keep fixing issues until all tests pass
3. When complete, you'll have passing tests

### As a Final Step in Other Workflows

This workflow is designed to be used as a final step in other workflows to ensure code quality:

```yaml
Your Workflow:
  icon: 🚀
  menu: buttons
  actions:
    - name: Implement Feature
      prompt: 'Implement user authentication'
      instantRun: true

    - name: Add Tests
      prompt: 'Write comprehensive tests for the authentication feature'
      instantRun: true

    - 'Tests Must Pass'  # Ensures all tests pass before completing
```

## Customization

### Using Different Test Commands

The workflow currently uses `npm test`. To use a different test runner, modify the first step:

```yaml
- name: 🧪 Run Tests
  prompt:
    command: 'yarn test 2>&1; echo "Exit code: $?"'  # For Yarn

- name: 🧪 Run Tests
  prompt:
    command: 'pytest 2>&1; echo "Exit code: $?"'  # For Python/pytest

- name: 🧪 Run Tests
  prompt:
    command: 'go test ./... 2>&1; echo "Exit code: $?"'  # For Go
```

## Benefits

- **Guaranteed test quality**: Tests must pass before the workflow completes
- **Automatic issue resolution**: No manual intervention needed to fix test failures
- **Full context**: AI receives complete test output for better debugging
- **Efficient**: Tests run only once per iteration (not in conditions)
- **Reusable**: Can be used standalone or as part of larger workflows
