#!/usr/bin/env npx tsx

import {
  getListByName,
  getCard,
  updateCard,
  moveCard,
  addComment,
  BOARD_ID,
} from "./trello-utils";

const DONE_LIST_NAME = "Done";
const TAKEN_PREFIX = "[🤖 AI Working]";

async function main() {
  const args = process.argv.slice(2);

  if (args.length < 2) {
    console.error("Usage: complete-task.ts <cardId> <summary>");
    process.exit(1);
  }

  const cardId = args[0];
  const summary = args.slice(1).join(" ");

  try {
    const doneList = await getListByName(BOARD_ID!, DONE_LIST_NAME);
    if (!doneList) {
      console.error(`ERROR: List "${DONE_LIST_NAME}" not found in board`);
      process.exit(1);
    }

    await moveCard(cardId, doneList.id);

    const timestamp = new Date().toISOString().split('T')[0];
    const commentText = `✅ **Task completed by AI** (${timestamp})\n\n${summary}`;
    await addComment(cardId, commentText);

    const cardData = await getCard(cardId);
    const originalName = cardData.name.replace(TAKEN_PREFIX, "").trim();
    await updateCard(cardId, originalName, undefined, "green");

    console.log(`SUCCESS: Task completed and moved to Done`);
    console.log(`Card: ${originalName}`);
    console.log(`Summary: ${summary}`);

  } catch (error: any) {
    console.error(`ERROR: ${error.message}`);
    process.exit(1);
  }
}

main();
