#!/usr/bin/env npx tsx

import {
  getListByName,
  getCards,
  BOARD_ID,
} from "./trello-utils";

const TODO_LIST_NAME = "Todo";
const TAKEN_PREFIX = "[🤖 AI Working]";

async function main() {
  try {
    const todoList = await getListByName(BOARD_ID!, TODO_LIST_NAME);
    if (!todoList) {
      console.error("ERROR: Todo list not found");
      process.exit(1);
    }

    const cards = await getCards(todoList.id);
    const currentCard = cards.find((card: any) => card.name.startsWith(TAKEN_PREFIX));

    if (!currentCard) {
      console.error("ERROR: No task in progress found");
      process.exit(1);
    }

    console.log(currentCard.id);
  } catch (error: any) {
    console.error(`ERROR: ${error.message}`);
    process.exit(1);
  }
}

main();
