#!/usr/bin/env npx tsx

import {
  getListByName,
  getCards,
  updateCard,
  BOARD_ID,
} from "./trello-utils";

const TODO_LIST_NAME = "Todo";
const TAKEN_PREFIX = "[🤖 AI Working]";

async function main() {
  try {
    // Find Todo list
    const todoList = await getListByName(BOARD_ID!, TODO_LIST_NAME);
    if (!todoList) {
      console.error(`ERROR: List "${TODO_LIST_NAME}" not found in board`);
      process.exit(1);
    }

    // Get all cards from Todo
    const cards = await getCards(todoList.id);

    // Find first card not taken by AI
    const nextCard = cards.find((card: any) => !card.name.startsWith(TAKEN_PREFIX));

    if (!nextCard) {
      console.log("NO_TASKS");
      process.exit(0);
    }

    // Mark card as taken by AI
    await updateCard(
      nextCard.id,
      `${TAKEN_PREFIX} ${nextCard.name}`,
      nextCard.desc,
      "yellow" // Yellow = in progress
    );

    // Output card data in structured format
    const output = JSON.stringify({
      id: nextCard.id,
      name: nextCard.name,
      description: nextCard.desc || "",
      url: nextCard.url,
    }, null, 2);

    console.log(output);

  } catch (error: any) {
    console.error(`ERROR: ${error.message}`);
    process.exit(1);
  }
}

main();
